package com.sfa.job.domain.system.dao;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.enums.StatusType;
import com.sfa.job.domain.system.entity.SysUser;
import com.sfa.job.domain.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-12-10 14
 * @describe :
 */
@Service
public class SysUserDaoImpl implements ISysUserDao{

    @Autowired
    private SysUserMapper sysUserMapper;

    @Override
    public void insertOrUpdate(JSONObject jo, Long deptId) {
        SysUser sysUser = new SysUser();
        sysUser.setCreateBy("admin");
        sysUser.setCreateUserId(1L);
        sysUser.setUpdateBy("admin");
        sysUser.setUpdateUserId(1L);

        sysUser.setDeptId(deptId);
        sysUser.setUserName(jo.getString("employee_no"));
        sysUser.setNickName(jo.getString("name"));
        sysUser.setUserType("00");
        sysUser.setFsUserId(jo.getString("user_id"));
        sysUser.setFsOpenId(jo.getString("open_id"));
        sysUser.setEmail(jo.getString("enterprise_email"));
        sysUser.setPhonenumber(jo.getString("mobile").replace("+86",""));
        sysUser.setSex("2");
        sysUser.setAvatar("");
        sysUser.setPassword("");
        sysUser.setRoleId(0L);
        sysUser.setRoleName("");
        sysUser.setWorkCityName(jo.getString("city"));
        sysUser.setStatus(StatusType.INVALID.getType()+"");
        sysUser.setLeaderFsOpenId(jo.getString("leader_user_id"));

        // 根据username（工号）查询
        SysUser sysUserOld = sysUserMapper.selectOne(new LambdaQueryWrapper<SysUser>().eq(SysUser::getUserName, sysUser.getUserName()));
        if (Objects.nonNull(sysUserOld)){
            sysUser.setUserId(sysUserOld.getUserId());
            sysUserMapper.putById(sysUser);
            return;
        }

        sysUserMapper.insert(sysUser);
    }

    @Override
    public void updateDeptLeader() {
        sysUserMapper.updateDeptLeader();
    }

    @Override
    public void deleteUser(String employeeNo) {
        sysUserMapper.updateStatus(employeeNo);
    }

    @Override
    public Map<String, String> getUserNoAndNameMap() {
        List<HashMap<String, String>> userNoAndNameMap = sysUserMapper.getUserNoAndNameMap();
        return userNoAndNameMap.stream().collect(Collectors.toMap(m -> m.get("user_name"), m -> m.get("nick_name")));
    }

    @Override
    public void updateOffboardDate(String employeeNo, Date offboardDate) {
        sysUserMapper.updateOffboardDate(employeeNo, offboardDate);
    }

    @Override
    public List<String> selectResignedUsers() {
        return sysUserMapper.selectResignedUsers();
    }

    @Override
    public void updateUserLeader() {
        sysUserMapper.updateUserLeader();
    }

    @Override
    public Map<String, String> selectListEmpAndLeader() {
        List<HashMap<String, String>> empAndLeaders = sysUserMapper.selectListEmpAndLeader();
        return empAndLeaders.stream().collect(Collectors.toMap(m -> m.get("user_name"), m -> m.get("leader_emp_code")));
    }
}
