package com.sfa.job.domain.qince.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.enums.qince.QinceEmpStatus;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.job.domain.qince.entity.QinceEmployee;
import com.sfa.job.domain.qince.mapper.QinceEmployeeMapper;
import com.sfa.job.pojo.qince.response.QinceEmployeeDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @author : liqiulin
 * @date : 2025-12-05 17
 * @describe :
 */
@DS("promotion")
@Service
public class QinceEmployeeDaoImpl implements IQinceEmployeeDao {
    @Autowired
    private QinceEmployeeMapper qinceEmployeeMapper;
    @Override
    public String getQcIdByEmpCode(String empCode) {
        LambdaQueryWrapper<QinceEmployee> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(QinceEmployee::getEmpCode, empCode);
        QinceEmployee qinceEmployee = qinceEmployeeMapper.selectOne(lambdaQueryWrapper);
        if (qinceEmployee == null){
            return null;
        }
        return qinceEmployee.getQcId();
    }

    @Override
    public void userResigned(String empQcId) {
        qinceEmployeeMapper.userResigned(empQcId);
    }

    /**
     * 根据code批量查询
     */
    @Override
    public List<QinceEmployeeDto> selectListByEmpcodes(Set<String> keySet) {
        LambdaQueryWrapper<QinceEmployee> qw = new LambdaQueryWrapper<>();
        qw.in(QinceEmployee::getEmpCode, keySet);
        qw.in(QinceEmployee::getEmpStatus, QinceEmpStatus.NORMAL.getStatus());
        List<QinceEmployee> qcEmployees = qinceEmployeeMapper.selectList(qw);
        return BeanUtils.transitionDtos(qcEmployees, QinceEmployeeDto.class);
    }
}
