package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.WdtQimenOrderDetailPayTimeDao;
import com.sfa.job.domain.order.entity.WdtQimenOrderDetailPayTime;
import com.sfa.job.domain.order.mapper.WdtQimenOrderDetailPayTimeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("sharding")
@Repository
public class WdtQimenOrderDetailPayTimeDaoImpl implements WdtQimenOrderDetailPayTimeDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private WdtQimenOrderDetailPayTimeMapper wdtQimenOrderDetailMapper;

    @Override
    public void saveOrUpdateBatch(List<WdtQimenOrderDetailPayTime> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<WdtQimenOrderDetailPayTime> batchLists = mergeList.subList(i, toIndex);
            wdtQimenOrderDetailMapper.saveOrUpdateBatch(batchLists);
        }
    }


}
