package com.sfa.job.service.feishu;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson2.JSONObject;
import com.lark.oapi.service.corehr.v2.model.*;
import com.sfa.common.core.enums.promotion.PlanStatus;
import com.sfa.common.core.utils.sdk.FeiShuUtil;
import com.sfa.job.domain.promotion.dao.IActivityPlanDao;
import com.sfa.job.domain.system.dao.ISysDeptDao;
import com.sfa.job.domain.system.dao.ISysUserDao;
import com.sfa.job.pojo.feishu.event.EventCallBackDto;
import com.sfa.job.pojo.promotion.response.ActivityPlanApprovalDto;
import com.sfa.job.util.T100Util;
import io.swagger.v3.core.util.Json;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-06-04 17
 * @describe :
 */
@Slf4j
@Service
public class EventCallbackServiceImpl implements IEventCallbackService{
    @Autowired
    private IActivityPlanDao activityPlanDao;
    @Autowired
    private ISysUserDao sysUserDao;
    @Autowired
    private ISysDeptDao sysDeptDao;
    @Autowired
    private FeiShuUtil feiShuUtil;
    @Autowired
    private T100Util t100Util;

    @Override
    public void planCP(EventCallBackDto.Event event) {
        String status = event.getStatus();
        String instanceId = event.getFsInstanceId();
        ActivityPlanApprovalDto planApproval = activityPlanDao.findPlanApproval(instanceId);
        if (planApproval == null){
            log.error("审批实例不存在：{}",event);
        }

        activityPlanDao.updateApprovalStatusById(planApproval.getId(),status);

        // 校验状态：已通过=已通过；非已通过=审批未通过
        PlanStatus planStatus = PlanStatus.APPROVED.name().equals(status) ? PlanStatus.NOT_EXECUTION : PlanStatus.REJECTED;
        Integer planStatusCode = planStatus.getCode();

        activityPlanDao.updateActivityPlanStatusByInstanceId(instanceId,planStatusCode);
    }

    @Override
    public void deptCreate(String departmentId) {
        JSONObject deptT100 = new JSONObject();
        Department dept = feiShuUtil.getDepartmentCorehr(departmentId);
        String deptCode = dept.getCode();
        String deptName = dept.getDepartmentName()[0].getValue();
        customFields(dept.getCustomFields(),deptT100);

        String parentDepartmentId = dept.getParentDepartmentId();
        Department parentdept = feiShuUtil.getDepartmentCorehr(parentDepartmentId);
        deptT100.put("top_level_department_no", deptCode.startsWith("ZX") ? "BJHQ" : parentdept.getCode());

        if (deptCode.startsWith("ZX")){
            deptT100.put("ooeg004",deptCode);
        }else {
            // 获取上级部门树、从而获取1级部门
            DepartmentParentInfo[] parentsDept = feiShuUtil.getParentsDepartmentReq(dept.getId());
            DepartmentParentInfo deptL1 = parentsDept[parentsDept.length - 2];

            // 获取1级部门编码
            Department deptInfoL1 = feiShuUtil.getDepartmentCorehr(deptL1.getDepartmentId());
            String deptCodeL1 = deptInfoL1.getCode();
            deptT100.put("ooeg004",deptCodeL1);
        }

        deptT100.put("data_status","A");
        deptT100.put("status","Y");
        deptT100.put("department_no",deptCode);
        deptT100.put("effective_date", "2024/05/01");
        deptT100.put("expiration_date",null);
        deptT100.put("corporation","ALL");
        deptT100.put("department_name_name",deptName);
        deptT100.put("department_shortname",deptName);
        deptT100.put("top_organization_no","ALL");
        deptT100.put("department_heads_employee_no","");
        deptT100.put("ooeg005","Y");
        createOrUpdateDept(deptT100);

    }

    @Override
    public void deptUpdate(String departmentId) {
        JSONObject deptT100 = new JSONObject();
        Department dept = feiShuUtil.getDepartmentCorehr(departmentId);
        // 部门启用状态，true为启用，false为停用
        Boolean active = dept.getActive();

        String deptCode = dept.getCode();
        I18n[] departmentName = dept.getDepartmentName();
        String deptName = active ? departmentName[0].getValue() : "（失效）"+departmentName[0].getValue();

        customFields(dept.getCustomFields(),deptT100);

        String parentDepartmentId = dept.getParentDepartmentId();
        Department parentdept = feiShuUtil.getDepartmentCorehr(parentDepartmentId);

        deptT100.put("data_status","AU");
        deptT100.put("status","Y");
        deptT100.put("department_no",deptCode);
        deptT100.put("top_level_department_no", Objects.nonNull(parentdept.getIsRoot()) && parentdept.getIsRoot() ? "BJHQ" : parentdept.getCode());
        deptT100.put("effective_date", "2024/05/01");
        deptT100.put("expiration_date",null);
        deptT100.put("corporation","ALL");
        deptT100.put("department_name",deptName);
        deptT100.put("department_shortname",deptName);
        deptT100.put("top_organization_no","ALL");
        deptT100.put("department_heads_employee_no","");
        deptT100.put("ooeg005","Y");
        createOrUpdateDept(deptT100);
        // 部门停用时，删除链路中心部门
        if (!active) {
            sysDeptDao.deleteDept(deptCode);
        }
    }

    /**
     * 员工入职
     */
    @Override
    public void userCreateOrUpdate(String employmentId) {
        Employee emp = feiShuUtil.getEmployeeReq(employmentId);
        userAUT100(emp);
    }

    /**
     * personId：创建人员信息时，生成的ID
     */
    @Override
    public void userUpdateByPersonId(String personId) {
        Employee emp = feiShuUtil.getPersonReq(personId);
        userAUT100(emp);
    }

    /**
     * 根据工号做员工离职
     */
    @Override
    public void userResigned(String employmentId) {
        Employee emp = feiShuUtil.getEmployeeReq(employmentId);
        String employeeNo = emp.getEmployeeNumber();
        if (StringUtils.isEmpty(employeeNo)){
            return;
        }
        // 链路中心人员离职
        sysUserDao.deleteUser(employeeNo);
    }

    private void userAUT100(Employee emp){
        String departmentIdV2 = emp.getDepartmentIdV2();
        Department dept = feiShuUtil.getDepartmentCorehr(departmentIdV2);
        String employeeNumber = emp.getEmployeeNumber();
        String deptCode = dept.getCode();
        String preferredName = emp.getPersonInfo().getPreferredName();
        // 判断部门，当部门为【新人训练营】时跳过，不做人员异动
        if (deptCode.equals("BM0131")){
            log.info("T100-AU-USER skip user：{}{}-新人训练营{}", preferredName,employeeNumber,deptCode);
            return;
        }
        BankAccount bankAccount = emp.getPersonInfo().getBankAccountList()[0];
        String bankAccountNumber = bankAccount.getBankAccountNumber();
        JSONObject userT100 = new JSONObject();
        userT100.put("data_status","AU");
        userT100.put("status","Y");
        userT100.put("employee_no",employeeNumber);
        userT100.put("department_no",deptCode);
        userT100.put("site_no","ALL");
        userT100.put("title","");
        userT100.put("bank_no","001");
        userT100.put("account",bankAccountNumber);
        userT100.put("employee_name",preferredName);
        userT100.put("employee_nickname",preferredName);
        userT100.put("phone","");
        userT100.put("mobilephone","ALL");
        userT100.put("email","");
        createOrUpdateUser(userT100);
    }
    private void customFields(CustomFieldData[] customFields,JSONObject deptT100){
        for (CustomFieldData customField : customFields) {
            String customName = customField.getName().getZhCn();
            String customValue = JSONObject.parse(customField.getValue()).getString("zh-CN");
            switch (customName) {
                case "责任中心":
                    deptT100.put("responsibility_center_type",customValue.substring(0,1));
                    break;
                case "费用类别":
                    deptT100.put("fee_type",customValue.substring(0,1));
                    break;
                default:
                    break;
            }
        }
    }

    private void createOrUpdateDept(JSONObject deptT100){
        JSONObject service = new JSONObject();
        service.put("name","department.create");
        JSONObject host = new JSONObject();
        host.put("acct","tiptop");
        host.put("ip","192.168.100.20");
        host.put("lang","zh_CN");
        host.put("prod","CRM");
        host.put("timestamp",DateUtil.format(new Date(), DatePattern.NORM_DATETIME_MS_PATTERN));
        JSONObject deptJson = new JSONObject();
        deptJson.put("service",service);
        deptJson.put("host",host);
        t100Util.createOrUpdateDept(deptJson,deptT100);
    }

    private void createOrUpdateUser(JSONObject userT100){
        JSONObject service = new JSONObject();
        service.put("name","employee.create");
        JSONObject host = new JSONObject();
        host.put("acct","tiptop");
        host.put("ip","192.168.100.20");
        host.put("lang","zh_CN");
        host.put("prod","CRM");
        host.put("timestamp",DateUtil.format(new Date(), DatePattern.NORM_DATETIME_MS_PATTERN));
        JSONObject payload = new JSONObject();
        payload.putObject("std_data").putObject("parameter").putArray("master_data").add(userT100);
        JSONObject userJson = new JSONObject();
        userJson.put("service",service);
        userJson.put("host",host);
        userJson.put("payload",payload);
        t100Util.createOrUpdateUser(userJson);
    }
}
