package com.sfa.job.xxljob.order;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpStatus;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.job.pojo.response.SyncOrderDetailDto;
import com.sfa.job.service.order.WdtQimenOrderSyncService;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author : 吕本才
 * @date : 2025年08月14日
 * @describe : 旺店通奇门订单数据
 */
@Component
@Slf4j
public class WdtQimenOrderTask {

    @Autowired
    WdtQimenOrderSyncService qimenSyncService;

    /**
     * 同步财务订单数据
     */
    @XxlJob("syncOrderQimenDetail")
    public SyncOrderDetailDto syncWdtQimenOrderDetail() {
        Long st = System.currentTimeMillis();
        // 暂不考虑分片
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        int shardingTotalCount = xxlJobContext.getShardTotal();
        int shardingItem = xxlJobContext.getShardIndex();
        XxlJobHelper.log(">>>>>>>>>>syncWangdiantongOrderDetail Job start<<<<<<<<<<");
        String jobParam = xxlJobContext.getJobParam();
        boolean jsonFlag = JSONUtil.isJson(jobParam);
        Date startTime = null;
        Date endTime = null;
        if (jsonFlag) {
            JSONObject jobParamJson = JSONObject.parseObject(jobParam);
            startTime = jobParamJson.getDate("startTime");
            endTime = jobParamJson.getDate("endTime");
        }

        // 简单模拟分片处理，这里输出每个分片的信息
        XxlJobHelper.log("分片总数: " + shardingTotalCount + ", 当前分片: " + shardingItem);
        XxlJobHelper.log("xxl-job开始同步-旺店通订单明细api接口数据");

        // 定时任务不设定开始时间和结束时间
        SyncOrderDetailDto detailDto = qimenSyncService.syncWdtQimenOrder(startTime, endTime, 0, 200L);
        XxlJobHelper.log("xxl-job结束同步-旺店通订单明细api接口数据, 共同步订单{}条数据，订单明细{}条,订单批次号：{},订单的开始时间{}和结束时间{}",
                detailDto.getOrderCount(), detailDto.getOrderDetailCount(), detailDto.getBatchNo(),
                DateUtil.formatDateTime(detailDto.getStartTime()), DateUtil.formatDateTime(detailDto.getEndTime()));
        if (ObjectUtil.equals(HttpStatus.HTTP_OK, detailDto.getCode())) {
            XxlJobHelper.handleSuccess(JSONObject.toJSONString(detailDto));
        } else {
            XxlJobHelper.handleFail(detailDto.getMessage());
        }
        return detailDto;
    }

}
