package com.sfa.job.service.feishu;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.sfa.job.domain.feishu.dao.IQinceMarketEmployeeDao;
import com.sfa.job.domain.use.dao.IFeishuSheetRecordDao;
import com.sfa.job.enums.FSRecordEnum;
import com.sfa.job.pojo.response.FeishuSheetRecordDto;
import com.sfa.job.util.FeiShuUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.stream.DoubleStream;

/**
 * @author : liqiulin
 * @date : 2025-05-09 16
 * @describe :
 */
@Service
public class PullSheetServiceImpl implements IPullSheetService{

    @Autowired
    private IFeishuSheetRecordDao feishushetRecordDao;
    @Autowired
    private IQinceMarketEmployeeDao qinceMarketEmployeeDao;
    @Autowired
    private FeiShuUtil feiShuUtil;

    /**
     * 拉取表格 - 勤策门店的城市经理、省区经理、大区总监
     */
    @Override
    public void qinceSotreManage() {
        FeishuSheetRecordDto recordDto = feishushetRecordDao.selectOne(FSRecordEnum.XS_USER_RELATION.getType());
        JSONObject jsonObject = feiShuUtil.pullSheetOneRange(recordDto.getSheetToken(), feiShuUtil.getBotToken1(), recordDto.getRanges());
        JSONArray values = jsonObject.getJSONArray("values");

        for (int i = 0; i < values.size(); i++) {
            JSONArray jsonArray = values.getJSONArray(i);
            qinceMarketEmployeeDao.insert(jsonArray);
        }
    }
}
