package com.sfa.job.service.erp.impl;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.job.domain.erp.dao.ErpAxmr005ShippingDetailsDao;
import com.sfa.job.pojo.response.FeishuSheetRecordDto;
import com.sfa.job.service.erp.ErpAxmr005Service;
import com.sfa.job.util.FeiShuUtil;
import com.sfa.job.domain.use.dao.IFeishuSheetRecordDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-04-08 13
 * @describe :
 */
@Service
public class ErpAxmr005ServiceImpl implements ErpAxmr005Service {
    @Autowired
    private ErpAxmr005ShippingDetailsDao erpAxmr005ShippingDetailsDao;
    @Autowired
    private IFeishuSheetRecordDao feishuSheetRecordDao;
    @Autowired
    private FeiShuUtil feiShuUtil;


    @Override
    public void axmr005ZQToFS(Date debitDate,Integer type) {
        List<Object> zhanquDataset = erpAxmr005ShippingDetailsDao.getZhanquDataset(debitDate);
        if (zhanquDataset.isEmpty()){
            return;
        }
        FeishuSheetRecordDto recordDto = feishuSheetRecordDao.selectOne(type);

        /**
         * 将结果推送到飞书表格，每次推100条
         */
        String range = recordDto.getSheetId() + "!A:H";
        String tenantAccessToken = feiShuUtil.getBotToken1();
        int batchSize = 100;
        for (int i = 0; i < zhanquDataset.size(); i+=batchSize) {
            // 计算当前批次的结束位置
            int end = Math.min(i + batchSize, zhanquDataset.size());
            List<Object> batch = zhanquDataset.subList(i, end);
            feiShuUtil.pushSetToSheet(range,batch,recordDto.getSheetToken(),tenantAccessToken);
        }
        putDateFormatCell(recordDto,tenantAccessToken);
    }

    public void putDateFormatCell(FeishuSheetRecordDto recordDto,String tenantAccessToken) {
        String range = recordDto.getSheetId() + "!C:C";
        Map<String, Object> appendStyle = new HashMap<>();
        Map<String, Object> style = new HashMap<>();
        style.put("formatter", "yyyy-MM-dd");
        appendStyle.put("range", range);
        appendStyle.put("style", style);

        Map<String, Object> body = new HashMap<>();
        body.put("appendStyle", appendStyle);
        feiShuUtil.appendStyle(recordDto.getSheetToken(),body,tenantAccessToken);
    }
}
