package com.sfa.job.domain.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * T100出货单中的物流单据
 * @TableName orders_sent
 */
@TableName(value ="orders_sent")
@Data
public class OrdersSent implements Serializable {
    /**
     * 发货单自增ID
     */
    @TableId(type = IdType.AUTO)
    private Long sendId;

    /**
     * 单据编号
     */
    private String ahSentNo;
    private String bjSentNo;

    /**
     * 版本号
     */
    private Integer bjSentVersion;

    /**
     * X06:销售出库单;N02:杂发单
     */
    private String type;

    /**
     * 过账日期
     */
    private Date postData;

    /**
     * 状态
     */
    private String status;

    /**
     * 运输公司编码
     */
    private String transport;

    /**
     * 运输公司
     */
    private String transportName;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * DD单号
     */
    private String ddNo;

    /**
     * 0：已推送；1：未推送（推送勤策）
     */
    private Integer pushQc;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}