package com.sfa.job.domain.feishu.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 勤策-区域销售人员架构表，来源：https://wangxiaolu.feishu.cn/sheets/I076slXhlhY2RdtDetEc17ornYd?sheet=49e4ba
 * @TableName qince_market_employee
 */
@Accessors(chain = true)
@TableName(value ="qince_market_employee")
@Data
public class QinceMarketEmployee implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 大区总监
     */
    private String dqEmpNo;

    /**
     * 大区总监
     */
    private String dqEmpName;

    /**
     * 战区负责人
     */
    private String zqEmpNo;

    /**
     * 战区负责人
     */
    private String zqEmpName;

    /**
     * 城市经理
     */
    private String csEmpNo;

    /**
     * 城市经理
     */
    private String csEmpName;

    /**
     * 员工
     */
    private String empNo;

    /**
     * 员工
     */
    private String empName;

    /**
     * CP系统修改时间
     */
    private Date modifyTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}