package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.FinanceOrderDao;
import com.sfa.job.domain.order.entity.FinanceOrder;
import com.sfa.job.domain.order.mapper.FinanceOrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class FinianceOrderDaoImpl implements FinanceOrderDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private FinanceOrderMapper financeOrderMapper;

    @Override
    public void saveOrUpdateBatch(List<FinanceOrder> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<FinanceOrder> batchLists = mergeList.subList(i, toIndex);
            financeOrderMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
