package com.sfa.job.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.lark.oapi.okhttp.*;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.job.pojo.request.WangdiantongQueryVO;
import com.sfa.job.pojo.response.WangdiantongQueryDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Slf4j
@Component
public class WangdiantongUtil {

    /**
     * 卖家账号/接口账号/盐/接口名称
     */
    public WangdiantongQueryDto queryWithDetail(WangdiantongQueryVO wangdiantongQuery, AtomicInteger beginPageNo) {
        WangdiantongQueryDto wangdiantongQueryDto = new WangdiantongQueryDto();
        JSONArray allArray = new JSONArray();
        Integer totalCount = 0;
        try {
            // 最大处理量，超过了，不再查询
            int maxDealCount = 500;
            int size = 0;
            int pageNo = beginPageNo.get();
            int maxPage = 0;

            do {
                String url = "http://wdt.wangdian.cn/openapi";
                String sid = "wxl3";
                String key = "wxl3-ota";
                String salt = "78784988049166748bfdc83273ebb990";
                String appsecret = "c65bd645bbed704bb7982037f9b948e3";
                String method = "sales.TradeQuery.queryWithDetail";
                String v = "1.0";

                HashMap<String, Object> params = new HashMap<>();
//                params.put("start_time", wangdiantongQuery.getStart_time());
//                params.put("end_time", wangdiantongQuery.getEnd_time());
                // bean 转map
                Map<String, Object> stringObjectMap = BeanUtil.beanToMap(wangdiantongQuery);
                params.putAll(stringObjectMap);

                List<HashMap<String, Object>> paramsList = Arrays.asList(params);

                String signParams = appsecret + "body" + JSONObject.toJSONString(paramsList) + "calc_total1" + "key" + key
                        + "method" + method + "page_no" + pageNo + "page_size200" + "salt" + salt + "sid" + sid +
                        "timestamp" + (System.currentTimeMillis() / 1000 - 1325347200) + "v" + v + appsecret;
                String sign = DigestUtils.md5DigestAsHex(signParams.toString().getBytes());
                log.debug(signParams);
                log.debug(sign);

                StringBuilder urlParams = new StringBuilder()
                        .append("sid=").append(sid)
                        .append("&key=").append(key)
                        .append("&salt=").append(salt)
                        .append("&method=").append(method)
                        .append("&v=").append(v)
                        .append("&timestamp=").append(System.currentTimeMillis() / 1000 - 1325347200)
                        .append("&sign=").append(sign)
                        .append("&page_size=").append(200)
                        .append("&page_no=").append(pageNo)
                        .append("&calc_total=").append(1);

                log.info("查询订单数据url:" + url + "?" + urlParams);

                RequestBody body = RequestBody.create(MediaType.get("application/json"), JSONObject.toJSONString(paramsList));
                Request urlRequestBuild = new Request.Builder().url(url + "?" + urlParams).post(body).build();
                OkHttpClient client = new OkHttpClient();
                Response execute = client.newCall(urlRequestBuild).execute();
                JSONObject responseJson = JSONObject.parseObject(execute.body().string());
                JSONObject dataR = responseJson.getJSONObject("data");
                JSONObject messageJson = responseJson.getJSONObject("message");
                if (ObjectUtils.isNotEmpty(messageJson)) {
                    log.error("访问旺店通接口错误" + messageJson.toString());
                    throw new ServiceException("访问旺店通接口错误" + messageJson.toString());
                }
                totalCount = dataR.getInteger("total_count");
                JSONArray orderJsonArray = dataR.getJSONArray("order");
                allArray.addAll(orderJsonArray);
                size = allArray.size();
                pageNo++;
                maxPage = (totalCount / 200);
                log.info("当前时间段{}-{},查询返回的order条数:{},总条数totalCount:{},page_no:{}", wangdiantongQuery.getStart_time(), wangdiantongQuery.getEnd_time(), orderJsonArray.size(), totalCount, pageNo);
            } while (size < maxDealCount && pageNo <= maxPage);
            if (pageNo >= maxPage) {
                beginPageNo.set(-1);
            } else {
                beginPageNo.set(pageNo);
            }
            wangdiantongQueryDto.setResult(allArray);
            wangdiantongQueryDto.setTotalCount(totalCount);
        } catch (Exception e) {
            // 记录异常日志
            log.error("异常信息：{}" + e.getMessage(), e);
            throw new ServiceException("旺店通接口获取数据错误" + e.getMessage());
        }
        return wangdiantongQueryDto;

    }
}
