package com.sfa.job.service.order.impl;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sfa.job.domain.order.entity.FinanceBaseProduct;
import com.sfa.job.domain.order.mapper.FinanceBaseProductMapper;
import com.sfa.job.service.order.FinanceBaseProductService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
@DS("bi")
@Slf4j
@Service
public class FinanceBaseProductServiceImpl extends ServiceImpl<FinanceBaseProductMapper, FinanceBaseProduct> implements FinanceBaseProductService {


    @Override
    public Map<String, FinanceBaseProduct> selectBaseProduct() {
        // 查询所有商品
        List<FinanceBaseProduct> list = list();
        // 以料号为key，商品对象为value，放入map中
        Map<String, FinanceBaseProduct> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getPrdCode(), v), HashMap::putAll);
        return map;
    }

}
