package com.sfa.job.domain.order.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.job.domain.order.dao.FinanceOrderDetailDao;
import com.sfa.job.domain.order.entity.FinanceOrderDetail;
import com.sfa.job.domain.order.mapper.FinanceOrderDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@DS("bi")
@Repository
public class FinianceOrderDetailDaoImpl implements FinanceOrderDetailDao {

    private static final int BATCH_SIZE = 1000;
    @Autowired
    private FinanceOrderDetailMapper financeOrderDetailMapper;

    @Override
    public void saveOrUpdateBatch(List<FinanceOrderDetail> mergeList) {
        for (int i = 0; i < mergeList.size(); i += BATCH_SIZE) {
            int toIndex = Math.min(i + BATCH_SIZE, mergeList.size());
            List<FinanceOrderDetail> batchLists = mergeList.subList(i, toIndex);
            financeOrderDetailMapper.saveOrUpdateBatch(batchLists);
        }
    }
}
