package com.sfa.common.core.enums.promotion;

/**
 * @author : liqiulin
 * @date : 2025-02-12 17
 * @describe :
 */
public enum PlanStatus {
    /**
     * 是否执行：1:执行；0：未执行；
     */
    EXECUTION(1, "执行"),
    NOT_EXECUTION(0, "未执行"),
    PENDING(2, "审批中"),
    REJECTED(3, "审批未通过"),
    WAIT(4, "待审批"),
    APPROVED(5, "已通过"),
    ;

    private final Integer code;
    private final String desc;

    PlanStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDesc(Integer code) {
        for (PlanStatus planStatus : PlanStatus.values()) {
            if (planStatus.getCode().equals(code)) {
                return planStatus.desc;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }
}
