package com.sfa.common.core.exception.auth;

import com.sfa.common.core.constant.StatusCode;

/**
 * 未能通过的登录认证异常
 *
 * @author ruoyi
 */

public class NotLoginException extends RuntimeException
{
    private static final long serialVersionUID = 1L;
    /**
     * 错误码
     */
    private Integer code;

    /**
     * 错误提示
     */
    private String msg;
    public NotLoginException(String message)
    {
        super(message);
    }

    public NotLoginException(StatusCode statusCode) {
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }
    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
