package com.sfa.common.core.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.sfa.common.core.domain.dao.BaseDao;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * BaseDao实现类，实现自定义通用方法，复用MyBatis-Plus的BaseMapper能力
 * @param <T> 实体类
 */
public class BaseDaoImpl<T>  implements BaseDao<T> {

    // 注入当前实体对应的Mapper（由Spring自动注入，需在子类中指定具体Mapper）
    // 直接使用 BaseMapper<T>
    protected BaseMapper<T> baseMapper;

    // 注入SqlSession，用于执行自定义SQL或批量操作（可选）
    @Autowired
    protected SqlSession sqlSession;

    // Setter方法，供子类设置具体的Mapper实例
    public void setBaseMapper(BaseMapper<T> baseMapper) {
        this.baseMapper = baseMapper;
    }

    // ------------------------------
    // 复用MyBatis-Plus的BaseMapper方法（直接委托给baseMapper）
    // ------------------------------
    @Override
    public int insert(T entity) {
        return baseMapper.insert(entity);
    }

    @Override
    public int deleteById(Serializable id) {
        return baseMapper.deleteById(id);
    }

    @Override
    public int deleteByMap(Map<String, Object> columnMap) {

        return baseMapper.deleteByMap(columnMap);
    }

    @Override
    public int delete(Wrapper<T> wrapper) {
        return  baseMapper.delete(wrapper);
    }

    @Override
    public int deleteBatchIds(Collection<? extends Serializable> idList) {
        return baseMapper.deleteBatchIds(idList);
    }

    @Override
    public int updateById(T entity) {
        return baseMapper.updateById(entity);
    }

    @Override
    public int update(T entity, Wrapper<T> updateWrapper) {
        return baseMapper.update(entity, updateWrapper);
    }

    @Override
    public T selectById(Serializable id) {
        return baseMapper.selectById(id);
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList) {
        return baseMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        return baseMapper.selectByMap(columnMap);
    }

    @Override
    public T selectOne(Wrapper<T> queryWrapper) {
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public Integer selectCount(Wrapper<T> queryWrapper) {
        return baseMapper.selectCount(queryWrapper);
    }

    @Override
    public List<T> selectList(Wrapper<T> queryWrapper) {
        return baseMapper.selectList(queryWrapper);
    }

    @Override
    public List<Map<String, Object>> selectMaps(Wrapper<T> queryWrapper) {
        return baseMapper.selectMaps(queryWrapper);
    }

    @Override
    public List<Object> selectObjs(Wrapper<T> queryWrapper) {
        return baseMapper.selectObjs(queryWrapper);
    }

    @Override
    public <E extends IPage<T>> E selectPage(E page, Wrapper<T> queryWrapper) {
        return baseMapper.selectPage(page, queryWrapper);
    }

    @Override
    public <E extends IPage<Map<String, Object>>> E selectMapsPage(E page, Wrapper<T> queryWrapper) {
        return baseMapper.selectMapsPage(page, queryWrapper);
    }

    // 其他BaseMapper方法（按需实现，或直接继承接口后委托）

    // ------------------------------
    // 实现自定义扩展方法
    // ------------------------------
    @Override
    public int batchInsert(List<T> list) {
        // 示例：通过SqlSession执行批量插入（需在Mapper.xml中定义batchInsert语句）
        return sqlSession.insert(getStatement("batchInsert"), list);
    }

    @Override
    public T selectByIdForUpdate(Serializable id) {
        // 示例：查询并加锁（需在Mapper.xml中定义selectByIdForUpdate语句）
        return sqlSession.selectOne(getStatement("selectByIdForUpdate"), id);
    }

    // 辅助方法：获取Mapper接口中的方法全名（namespace + method）
    private String getStatement(String method) {
        // 获取当前Mapper的类路径（如com.ruoyi.mapper.UserMapper）
        // 由于baseMapper是接口代理对象，需要获取其接口信息
        Class<?>[] interfaces = baseMapper.getClass().getInterfaces();
        if (interfaces.length > 0) {
            String className = interfaces[0].getName();
            return className + "." + method;
        }
        throw new RuntimeException("无法获取Mapper接口信息");
    }
}