package com.sfa.common.core.domain.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.io.Serializable;
import java.util.List;

/**
 * 自定义BaseDao接口，继承MyBatis-Plus的BaseMapper，扩展通用方法
 * @param <T> 实体类
 */
public interface BaseDao<T> extends BaseMapper<T> {

    // 扩展自定义通用方法（示例）
    /**
     * 批量插入（非MyBatis-Plus默认方法，自定义实现）
     */
    int batchInsert(List<T> list);

    /**
     * 根据ID查询并锁定行（悲观锁）
     */
    T selectByIdForUpdate(Serializable id);
}
