package com.sfa.common.core.web.page;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.text.Convert;
import com.sfa.common.core.utils.ServletUtils;
import com.sfa.common.core.web.domain.PageInfo;

/**
 * 表格数据处理
 *
 * @author ruoyi
 */
public class TableSupport {
    /**
     * 当前记录起始索引
     */
    public static final String PAGE_NUM = "pageNum";

    /**
     * 每页显示记录数
     */
    public static final String PAGE_SIZE = "pageSize";

    /**
     * 排序列
     */
    public static final String ORDER_BY_COLUMN = "orderByColumn";

    /**
     * 排序的方向 "desc" 或者 "asc".
     */
    public static final String IS_ASC = "isAsc";

    /**
     * 分页参数合理化
     */
    public static final String REASONABLE = "reasonable";

    /**
     * 封装分页对象
     */
    public static PageDomain getPageDomain() {
        PageDomain pageDomain = new PageDomain();
        pageDomain.setPageNum(Convert.toInt(ServletUtils.getParameter(PAGE_NUM), 1));
        pageDomain.setPageSize(Convert.toInt(ServletUtils.getParameter(PAGE_SIZE), 10));
        pageDomain.setOrderByColumn(ServletUtils.getParameter(ORDER_BY_COLUMN));
        pageDomain.setIsAsc(ServletUtils.getParameter(IS_ASC));
        pageDomain.setReasonable(ServletUtils.getParameterToBool(REASONABLE));
        return pageDomain;
    }

    public static PageDomain buildPageRequest() {
        return getPageDomain();
    }

    public static <T> Page<T> pageI() {
        Page<T> page = new Page<T>(Convert.toInt(ServletUtils.getParameter(PAGE_NUM), 1), Convert.toInt(ServletUtils.getParameter(PAGE_SIZE), 10));
        return page;
    }

    public static <T> PageInfo<T> pageInfo() {
        PageInfo<T> pageInfo = new PageInfo<>();
        pageInfo.setPageNum(Convert.toInt(ServletUtils.getParameter(PAGE_NUM), 1));
        pageInfo.setPageSize(Convert.toInt(ServletUtils.getParameter(PAGE_SIZE), 10));
        return pageInfo;
    }
}
