package com.sfa.common.core.utils.wechat;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

/**
 * @author : liqiulin
 * @date : 2024-04-15 15
 * @describe :
 */
@Slf4j
public class WeChatPlatFormUtils {
    // 微信模板消息接口地址
    private static final String TEMPLATE_SEND_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send";
    private static final String MINI_PROGRAM_CODE2SESSION_URL = "https://api.weixin.qq.com/sns/jscode2session";

    private static final String ACCESS_TOKEN_URL =  "https://api.weixin.qq.com/cgi-bin/token";
    public static Object isSubscribe(String openId, String templateId, String accessToken) {
        String url = TEMPLATE_SEND_URL + "?access_token=" + accessToken;

        // 构造一个无效的模板消息内容
        String jsonBody = String.format(
                "{\"touser\":\"%s\",\"template_id\":\"%s\",\"data\":{\"keyword1\":{\"value\":\"test\"}}}",
                openId, templateId
        );

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(new StringEntity(jsonBody, "UTF-8"));
            httpPost.setHeader("Content-type", "application/json");

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                String result = EntityUtils.toString(response.getEntity(), "UTF-8");
                JSONObject jsonObject = JSON.parseObject(result);
                log.info("result: {}", jsonObject.toString());
                Integer errCode = jsonObject.getInteger("errcode");
                log.info("errCode: {}", errCode);
                // 根据错误码判断
                if (errCode != null) {
                    return errCode != 43004;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取"+templateId+"是否订阅"+openId+"失败"+e.getMessage(), e);
        }
        return false;
    }

    /**
     * 服务号、小程序获取access_token
     * @param appId
     * @param appSecret
     * @return
     */
    public static JSONObject getMiniappAccessToken(String appId, String appSecret) {
        // 需要缓存
        String cacheKey = "wx_access_token：" + appId;

        String url = ACCESS_TOKEN_URL +"?grant_type=client_credential&appid=" + appId + "&secret=" + appSecret;
        String body = HttpUtil.createGet(url).execute().body();
        JSONObject jsonObject = JSONObject.parseObject(body);

        return jsonObject;
    }

    public JSONObject getUserPhoneByAccessToken(String accessToken, String code) {
        JSONObject param = new JSONObject();
        param.put("code", code);
        String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + accessToken;
        String body = HttpUtil.createPost(url).body(param.toString()).execute().body();
        return JSONObject.parseObject(body);
    }

    public static JSONObject getOpenid(String jsCode, String xltAppId, String xltAppSecret) {
        String url = MINI_PROGRAM_CODE2SESSION_URL +"?appid=" + xltAppId + "&secret=" + xltAppSecret + "&js_code=" + jsCode + "&grant_type=authorization_code";
        String body = HttpUtil.createGet(url).execute().body();
        return JSONObject.parseObject(body);
    }
}
