package com.sfa.common.core.enums;

import com.sfa.common.core.constant.StatusCode;

/**
 * @author : liqiulin
 * @date : 2024-10-29 16
 * @describe :
 */
public enum ECode implements StatusCode {

    /**
     * 700+ :SQL统一异常（不分模块）
     */
//    唯一键冲突
    DB_TABLE_UNIQUE_EXIST(700, "%s已存在，不可重复；"),
    DB_TABLE_FLAG_NOTEXIST(701, "当前数据异常或已被他人修改，请刷新重试；"),
    DB_TABLE_UPDATE_ERROR(702, "数据保存异常，请刷新重试；"),
    SELECT_SQL_NULL_ERROR(703, "查询异常，无查询语句；"),



    /**
     * 800+ :Param_参数_统一异常（不分模块）
     */
    PARAM_ID_ISNULL_ERROR(800, "缺失 - %sID；"),
    PARAM_CODE_ISNULL_ERROR(801, "缺失 - %s编码；"),


    /**
     * 900+ :operation模块错误
     */
    KQMX_CURRENTLY_TYPE_KQ_HAS(900, "不可重复打卡；"),
    KQMX_CLOCK_IN_ERRPR(901, "考勤异常；"),



    ;
    private int code;
    private String msg;

    ECode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

}