package com.sfa.common.core.enums;

import com.sfa.common.core.constant.StatusCode;

/**
 * @author : liqiulin
 * @date : 2024-10-29 16
 * @describe :
 */
public enum ECode implements StatusCode {

    /**
     * 600+ :数据异常（不分模块）
     */
    DATA_NULL_ERROR(600, "数据失效或为空；"),

    /**
     * 700+ :SQL统一异常（不分模块）
     */
//    唯一键冲突
    DB_TABLE_UNIQUE_EXIST(700, "%s已存在，不可重复；"),
    DB_TABLE_FLAG_NOTEXIST(701, "当前数据异常或已被他人修改，请刷新重试；"),
    DB_TABLE_UPDATE_ERROR(702, "数据保存异常，请刷新重试；"),
    SELECT_SQL_NULL_ERROR(703, "查询异常，无查询语句；"),



    /**
     * 800+ :Param_参数_统一异常（不分模块）
     */
    PARAM_ID_ISNULL_ERROR(800, "缺失 - %sID；"),
    PARAM_CODE_ISNULL_ERROR(801, "缺失 - %s编码；"),
    LEAST_INCLUDE_ONE_ERROR(802, "最少选择一项；"),


    /**
     * 900+ :operation模块错误
     */
    KQMX_CURRENTLY_TYPE_KQ_HAS(900, "不可重复打卡；"),
    KQMX_CLOCK_IN_ERRPR(901, "考勤异常；"),
    FS_CREATE_APPROVAL_ERROR(902, "%s"),


    /**
     * system模块 1000+：sys 模块错误
     */
    FEISHU_ACCESS_TOKEN_ERROR(1000, "飞书用户获取失败；"),
    QC_ACCESS_TOKEN_ERROR(1001, "勤策用户获取失败；"),

    /**
     * 2000+ :job 模块
     */
    JINGDONG_TC_ORDER_TRACE_QUERY_ERROR(2001, "获取京东TC物流轨迹失败；"),
    JINGDONG_TC_ORDER_TRACE_API_ERROR(2002, "请求京东TC物流轨迹接口返回异常；"),
    KYE_ORDER_TRACE_QUERY_ERROR(2003, "获取跨越物流轨迹失败；"),
    SENT_ISNULL_ERROR(2004, "物流单异常，未找到；"),
    SENT_NO_QUERY_COUNT_ERROR(2005, "查询次数过多，每小时只能查询5次；"),
    KYE_ORDER_TRACE_API_ERROR(2006, "请求跨越物流轨迹接口返回异常；"),

    ;
    private int code;
    private String msg;

    ECode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

}
