package com.sfa.common.core.exception;

import com.sfa.common.core.constant.StatusCode;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe : 参数异常
 */
public class WXLSQLException extends RuntimeException {
    private int code;
    private String msg;

    public WXLSQLException(StatusCode statusCode) {
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }

    public WXLSQLException(StatusCode statusCode, Object... strs) {
        this.code = statusCode.getCode();
        this.msg = String.format(statusCode.getMsg(), strs);
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
