package com.sfa.common.core.exception;

import com.sfa.common.core.constant.StatusCode;

/**
 * 检查异常
 *
 * @author ruoyi
 */
public class CheckedException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    private int code;
    private String msg;

    public CheckedException(StatusCode statusCode, Object... strs) {
        this.code = statusCode.getCode();
        this.msg = String.format(statusCode.getMsg(), strs);
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

//    public CheckedException(String message) {
//        super(message);
//    }
//
//    public CheckedException(Throwable cause) {
//        super(cause);
//    }
//
//    public CheckedException(String message, Throwable cause) {
//        super(message, cause);
//    }
//
//    public CheckedException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
//        super(message, cause, enableSuppression, writableStackTrace);
//    }
}
