package com.sfa.auth.util;

import com.alibaba.fastjson2.JSONObject;
import com.lark.oapi.okhttp.*;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.auth.NotLoginException;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.HashMap;

/**
 * @author : liqiulin
 * @date : 2025-03-26 11
 * @describe :
 */
@Component
public class QinCeUtil {

    private static final String QINCE_OSS_URL = "https://sso.qince.com/service/oauth";
    private static final String APP_ID = "app1742881477251";
    private static final String APP_SECRET = "wr87Ozn7Dp10rR656xRCxfuxOxYs9OR0";
    private static final String TENANT_ID = "6035565720566270399";

    public String getAccessToken() {
        try {
            String ossUrl = QINCE_OSS_URL+"/token";
            HashMap<String, String> bodyMap = new HashMap<>();
            bodyMap.put("app_id", APP_ID);
            bodyMap.put("app_secret", APP_SECRET);
            bodyMap.put("tenant_id", TENANT_ID);

            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create(MediaType.parse("application/json"), JSONObject.toJSONString(bodyMap));
            Request request = new Request.Builder().url(ossUrl).post(body).build();

            Response execute = client.newCall(request).execute();
            JSONObject rj = JSONObject.parseObject(execute.body().string());

            Integer returnCode = rj.getInteger("return_code");
            if (returnCode != 0){
                throw new NotLoginException(ECode.QC_ACCESS_TOKEN_ERROR);
            }
            return rj.getJSONObject("return_data").getString("access_token");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }

    /**
     * 获取当前登录人的登录账号
     * @param accessToken
     * @param code
     * @return
     */
    public String getUserInfo(String accessToken, String code) {
        try {
            String ossUrl = QINCE_OSS_URL + "/userinfo?access_token=" + accessToken + "&code=" + code;
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(ossUrl).get().build();
            Response execute = client.newCall(request).execute();
            JSONObject rj = JSONObject.parseObject(execute.body().string());

            Integer returnCode = rj.getInteger("return_code");
            if (returnCode != 0){
                throw new NotLoginException(ECode.QC_ACCESS_TOKEN_ERROR);
            }
            return rj.getJSONObject("return_data").getString("code");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }
}













