package com.sfa.auth;

import com.sfa.common.security.annotation.EnableRyFeignClients;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;

/**
 * 认证授权中心
 * 
 * @author ruoyi
 */
@ComponentScan(basePackages = {"com.sfa.common.core.utils.sdk","com.sfa.auth"})
@EnableRyFeignClients
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class })
public class SfaAuthApplication
{
    public static void main(String[] args)
    {
        SpringApplication.run(SfaAuthApplication.class, args);
    }
}
