package com.sfa.auth.controller;

import com.lark.oapi.service.authen.v1.model.GetUserInfoRespBody;
import com.sfa.auth.form.LoginBody;
import com.sfa.auth.service.SysLoginService;
import com.sfa.auth.util.FeiShuUtil;
import com.sfa.common.security.service.TokenService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-12-19 13
 * @describe : 飞书免登
 */
@RestController
public class FsTokenController {
    @Autowired
    FeiShuUtil feiShuUtil;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SysLoginService sysLoginService;

    @PostMapping("/fs/login")
    public Map<String, Object> login(@RequestBody LoginBody form){
        String userAccessToken = feiShuUtil.createUserAccessToken(form.getCode());
        GetUserInfoRespBody fsUserInfo = feiShuUtil.getUserInfo(userAccessToken);
        LoginUser userInfo = sysLoginService.fsLogin(fsUserInfo.getEmployeeNo());
        return tokenService.createToken(userInfo);
    }
}
