package com.sfa.auth.util;

import com.alibaba.fastjson2.JSONObject;
import com.google.gson.JsonParser;
import com.lark.oapi.Client;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.okhttp.*;
import com.lark.oapi.service.authen.v1.model.GetUserInfoResp;
import com.lark.oapi.service.authen.v1.model.GetUserInfoRespBody;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.auth.NotLoginException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;

/**
 * @author : liqiulin
 * @date : 2024-12-06 16
 * @describe :
 */
@Slf4j
@Component
public class FeiShuUtil {
    //飞书获取用户信息，注意值：最后的斜杆
    @Value("${feishu.redirectUri}")
    private String redirectUri;
    /**
     * 根据用户的登录临时code获取useraccessToken
     */
    public String createUserAccessToken(String code) {
        try {
            HashMap<String, String> bodyMap = new HashMap<>();
            bodyMap.put("grant_type", "authorization_code");
            bodyMap.put("client_id", "cli_a7dbe3ec7d9e5013");
            bodyMap.put("client_secret", "WxiT7uIJNDbDpEGfVCXEwNNfN1A3RgUo");
            bodyMap.put("redirect_uri", redirectUri);

            bodyMap.put("code", code);

            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create(MediaType.get("application/json"), JSONObject.toJSONString(bodyMap));
            Request build = new Request.Builder().url("https://open.feishu.cn/open-apis/authen/v2/oauth/token").addHeader("Content-Type", "application/json; charset=utf-8").post(body).build();
            Response execute = client.newCall(build).execute();
            JSONObject rj = JSONObject.parseObject(execute.body().string());
            if (!rj.containsKey("access_token")){
                log.error("飞书用户获取失败！",rj.toString());
                throw new NotLoginException(ECode.FEISHU_ACCESS_TOKEN_ERROR);
            }
            return rj.getString("access_token");
        } catch (Exception e) {
            throw new NotLoginException(ECode.FEISHU_ACCESS_TOKEN_ERROR);
        }
    }

    /**
     * 根据用户的userAccessToken获取用户信息
     */
    public GetUserInfoRespBody getUserInfo(String userAccessToken) {
        try {
            Client client = getClient();
            GetUserInfoResp resp = client.authen().userInfo().get(RequestOptions.newBuilder()
                    .userAccessToken(userAccessToken)
                    .build());
            if (!resp.success()) {
                log.error(String.format("code:%s,msg:%s,reqId:%s, resp:%s",
                        resp.getCode(), resp.getMsg(), resp.getRequestId(), Jsons.createGSON(true, false).toJson(JsonParser.parseString(new String(resp.getRawResponse().getBody(), "UTF-8")))));
                return null;
            }
            return resp.getData();
        } catch (Exception e) {
            log.error("获取用户信息失败，停止执行！");
            return null;
        }
    }

    private Client getClient() {
        return Client.newBuilder("cli_a7dbe3ec7d9e5013", "WxiT7uIJNDbDpEGfVCXEwNNfN1A3RgUo").build();
    }
}
