package com.sfa.auth.controller;

import com.sfa.auth.service.SysLoginService;
import com.sfa.auth.util.QinCeUtil;
import com.sfa.common.security.service.TokenService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-03-25 17
 * @describe : 勤策登录
 */
@RestController
public class QcTokenController {

    @Autowired
    private TokenService tokenService;
    @Autowired
    private QinCeUtil qinCeUtil;
    @Autowired
    private SysLoginService sysLoginService;

    @GetMapping("/qc/login")
    public Map<String, Object> login(String code){
        String accessToken = qinCeUtil.getAccessToken();
        String employeeNo = qinCeUtil.getUserInfo(accessToken, code);
        LoginUser loginUser = sysLoginService.fsLogin(employeeNo);
        return tokenService.createToken(loginUser);
    }
}
