package com.sfa.system.api;

import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.constant.ServiceNameConstants;
import com.sfa.common.core.domain.R;
import com.sfa.system.api.factory.RemoteKqRuleFallbackFactory;
import com.sfa.system.api.pojo.response.MdmKqRuleDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * @author : liqiulin
 * @date : 2024-11-04 19
 * @describe : 考勤规则
 */
@FeignClient(contextId = "RemoteKqRuleService", value = ServiceNameConstants.SYSTEM_SERVICE, fallbackFactory = RemoteKqRuleFallbackFactory.class)
public interface RemoteKqRuleService {
    @GetMapping(value = "/system/kq_rule/{ruleId}")
    public R<MdmKqRuleDto> getInfo(@PathVariable("ruleId") Long ruleId, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

}
