package com.sfa.system.api.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * 用户对象 sys_user
 *
 * @author ruoyi
 */
@NoArgsConstructor
@Data
@TableName(value = "sys_user")
public class SysUser extends BaseDo
{
    private static final long serialVersionUID = 1L;

    /** 用户ID */
    @TableId(type = IdType.AUTO)
    private Long userId;

    /** 部门ID */
    private Long deptId;

    /** 用户账号 */
    private String userName;

    /** 用户昵称 */
    private String nickName;

    /** 用户邮箱 */
    private String email;

    /** 手机号码 */
    private String phonenumber;

    /** 用户性别 */
    private String sex;

    /** 用户头像 */
    private String avatar;

    /** 密码 */
    private String password;

    /** 角色ID */
    private Long roleId;

    /** 角色名称 */
    private String roleName;

    /** 岗位编码 */
    private Long postId;

    /** 岗位名称 */
    private String postName;

    /** 考勤规则Id */
    private Long ruleId;

    /** 考勤名称 */
    private String ruleName;

    /**
     * 工作-省编码
     */
    private String workProvinceNum;

    /**
     * 工作-省名称
     */
    private String workProvinceName;

    /**
     * 工作-市编码
     */
    private String workCityNum;

    /**
     * 工作-市编码
     */
    private String workCityName;

    /** 帐号状态（0正常 1停用） */
    private String status;

    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;

    /** 最后登录IP */
    private String loginIp;

    /** 最后登录时间 */
    private Date loginDate;

    /** 部门对象 */
    @TableField(exist = false)
    private SysDept dept;

    /** 角色对象 */
    @TableField(exist = false)
    private List<SysRole> roles;

    /** 角色组 */
    @TableField(exist = false)
    private Long[] roleIds;

    /** 岗位组 */
    @TableField(exist = false)
    private Long[] postIds;

    public boolean isAdmin()
    {
        return isAdmin(this.userId);
    }

    public static boolean isAdmin(Long userId)
    {
        return userId != null && 1L == userId;
    }

    public SysUser(Long userId) {
        this.userId = userId;
    }
}
