package com.sfa.system.api.factory;

import com.sfa.common.core.domain.R;
import com.sfa.system.api.RemoteKqRuleService;
import com.sfa.system.api.pojo.response.MdmKqRuleDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-11-04 19
 * @describe :考勤规则
 */
@Component
public class RemoteKqRuleFallbackFactory implements FallbackFactory<RemoteKqRuleService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogFallbackFactory.class);

    @Override
    public RemoteKqRuleService create(Throwable cause) {
        log.error("考勤规则查询信息失败:{}", cause.getMessage());
        return new RemoteKqRuleService() {
            @Override
            public R<MdmKqRuleDto> getInfo(Long ruleId, String source) {
                return R.fail("考勤规则查询信息失败:" + cause.getMessage());
            }
        };
    }
}
