package com.sfa.system.api.pojo.response;

import com.sfa.common.core.annotation.Excel;
import com.sfa.common.core.annotation.Excels;
import com.sfa.system.api.domain.SysDept;
import com.sfa.system.api.domain.SysRole;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-10-31 13
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserDto {

    /** 用户ID */
    @Excel(name = "用户序号", type = Excel.Type.EXPORT, cellType = Excel.ColumnType.NUMERIC, prompt = "用户编号")
    private Long userId;

    /** 部门ID */
    @Excel(name = "部门编号", type = Excel.Type.IMPORT)
    private Long deptId;

    /** 用户账号 */
    @Excel(name = "登录名称")
    private String userName;

    /** 用户昵称 */
    @Excel(name = "用户名称")
    private String nickName;

    /** 用户邮箱 */
    @Excel(name = "用户邮箱")
    private String email;

    /** 手机号码 */
    @Excel(name = "手机号码", cellType = Excel.ColumnType.TEXT)
    private String phonenumber;

    /** 用户性别 */
    @Excel(name = "用户性别", readConverterExp = "0=男,1=女,2=未知")
    private String sex;

    /** 用户头像 */
    private String avatar;

    /** 岗位编码 */
    private Long postId;

    /** 岗位名称 */
    private String postName;

    /** 规则编号 */
    private String ruleId;

    /** 规则名称 */
    private String ruleName;

    /** 帐号状态（0正常 1停用） */
    @Excel(name = "帐号状态", readConverterExp = "0=正常,1=停用")
    private String status;

    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;

    /** 最后登录IP */
    @Excel(name = "最后登录IP", type = Excel.Type.EXPORT)
    private String loginIp;

    /** 最后登录时间 */
    @Excel(name = "最后登录时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss", type = Excel.Type.EXPORT)
    private Date loginDate;

    /** 部门对象 */
    @Excels({
            @Excel(name = "部门名称", targetAttr = "deptName", type = Excel.Type.EXPORT),
            @Excel(name = "部门负责人", targetAttr = "leader", type = Excel.Type.EXPORT)
    })
    private SysDept dept;

    /** 角色对象 */
    private List<SysRole> roles;

    /** 角色组 */
    private Long[] roleIds;

    /** 岗位组 */
    private Long[] postIds;

    /** 角色ID */
    private Long roleId;

    /** 角色名称 */
    private String roleName;

    /**
     * 工作-省编码
     */
    private String workProvinceNum;

    /**
     * 工作-省名称
     */
    private String workProvinceName;

    /**
     * 工作-市编码
     */
    private String workCityNum;

    /**
     * 工作-市编码
     */
    private String workCityName;


    /** 创建者 */
    private String createBy;

    /** 创建者 */
    private Long createUserId;

    /** 创建时间 */
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新者 */
    private Long updateUserId;

    /** 更新时间 */
    private Date updateTime;

    /** 备注 */
    private String remark;

    /**
     * 判断是否开通促销账号
     */
    private Boolean isOpenPromotion;

    /**
     * 权限(1:oneself,2:admin)
     */
    private Integer privilegeId;

    /**
     * 促销帐号状态（0:正常 1:停用）
     */
    private String proStatus;
}
