package com.sfa.system.api.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

/**
 * 部门表 sys_dept
 * 
 * @author ruoyi
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@TableName(value = "sys_dept")
public class SysDept extends BaseDo
{
    private static final long serialVersionUID = 1L;

    /** 部门ID */
    @TableId(type = IdType.AUTO)
    private Long deptId;

    /**
     * 部门编号(飞书-department_id)
     */
    private String deptCode;

    /** 父部门ID */
    private Long parentId;
    /** 父部门名称 */
    private String parentName;
    private String parentCode;

    /**
     * 父部门飞书部门ID
     */
    private String parentFsId;

    /** 祖级列表 */
    private String ancestors;
    private String ancestorCodes;
    private String ancestorNames;

    /** 部门名称 */
    @NotBlank(message = "部门名称不能为空")
    @Size(min = 0, max = 30, message = "部门名称长度不能超过30个字符")
    private String deptName;
    private String deptNamesSale;

    /**
     * 飞书部门IDopen_department_id
     */
    private String fsDeptId;

    /** 显示顺序 */
    private Integer orderNum;

    /** 负责人 */
    private String leader;

    /**
     * 飞书负责人id
     */
    private String fsLeaderId;

    /** 联系电话 */
    @Size(min = 0, max = 11, message = "联系电话长度不能超过11个字符")
    private String phone;

    /** 邮箱 */
    private String email;

    /**
     * 部门人数
     */
    private Integer memberCount;

    /** 部门状态:0正常,1停用 */
    private String status;

    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;

    /** 子部门 */
    @TableField(exist = false)
    private List<SysDept> children = new ArrayList<SysDept>();
}
