package com.sfa.system.api;

import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.constant.ServiceNameConstants;
import com.sfa.common.core.domain.R;
import com.sfa.system.api.factory.RemoteSiteFallbackFactory;
import com.sfa.system.api.pojo.response.SiteDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * @author : liqiulin
 * @date : 2024-11-04 19
 * @describe : 关于地点/区域/位置等查询信息
 */
@FeignClient(contextId = "RemoteSiteService", value = ServiceNameConstants.SYSTEM_SERVICE, fallbackFactory = RemoteSiteFallbackFactory.class)
public interface RemoteSiteService {
    @PostMapping("/system/site/query/county")
    public R<SiteDto> getCountyName(@RequestBody SiteDto siteDto, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

}
