package com.sfa.system.api;

import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.constant.ServiceNameConstants;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.system.api.domain.SysUser;
import com.sfa.system.api.factory.RemoteUserFallbackFactory;
import com.sfa.system.api.model.LoginUser;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 用户服务
 *
 * @author ruoyi
 */
@FeignClient(contextId = "remoteUserService", value = ServiceNameConstants.SYSTEM_SERVICE, fallbackFactory = RemoteUserFallbackFactory.class)
public interface RemoteUserService {
    /**
     * 通过用户名查询用户信息
     *
     * @param username 用户名
     * @param source   请求来源
     * @return 结果
     */
    @GetMapping("/system/user/info/{username}")
    public R<LoginUser> getUserInfo(@PathVariable("username") String username, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    @GetMapping("/system/user/userInfoById")
    public R<SysUser> getUserInfoById(@RequestParam("userId") Long userId, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 注册用户信息
     *
     * @param sysUser 用户信息
     * @param source  请求来源
     * @return 结果
     */
    @PostMapping("/system/user/register")
    public R<Boolean> registerUserInfo(@RequestBody SysUser sysUser, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    /**
     * 记录用户登录IP地址和登录时间
     *
     * @param sysUser 用户信息
     * @param source  请求来源
     * @return 结果
     */
    @PutMapping("/system/user/recordlogin")
    public R<Boolean> recordUserLogin(@RequestBody SysUser sysUser, @RequestHeader(SecurityConstants.FROM_SOURCE) String source);

    @PostMapping("/system/user/getUserInfoByIds")
    public R<PageInfo<SysUser>> getUserInfoByIds(@RequestParam("pageSize") Integer pageSize,  // URL查询参数
                                                 @RequestParam("pageNum") Integer pageNum,   // URL查询参数
                                                 @RequestBody List<Long> userIds,
                                                 @RequestHeader(SecurityConstants.FROM_SOURCE) String source);
}
