package com.sfa.system.api.factory;

import com.sfa.common.core.domain.R;
import com.sfa.system.api.RemoteSiteService;
import com.sfa.system.api.pojo.response.SiteDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-11-04 19
 * @describe :
 */
@Component
public class RemoteSiteFallbackFactory implements FallbackFactory<RemoteSiteService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogFallbackFactory.class);

    @Override
    public RemoteSiteService create(Throwable throwable)
    {
        log.error("地点/区域/位置等查询信息失败:{}", throwable.getMessage());
        return new RemoteSiteService()
        {
            @Override
            public R<SiteDto> getCountyName(SiteDto siteDto, String source) {
                return R.fail("地点/区域/位置等查询信息失败:" + throwable.getMessage());
            }
        };

    }
}
