/**
* 显示消息提示框
* @param content 提示的标题
*/
export function toast(content) {
  uni.showToast({
    icon: 'none',
    title: content
  })
}

/**
* 显示模态弹窗
* @param content 提示的标题
*/
export function showConfirm(content) {
  return new Promise((resolve, reject) => {
    uni.showModal({
      title: '提示',
      content: content,
      cancelText: '取消',
      confirmText: '确定',
      success: function (res) {
        resolve(res)
      }
    })
  })
}

/**
* 参数处理
* @param params 参数
*/
export function tansParams(params) {
  let result = ''
  for (const propName of Object.keys(params)) {
    const value = params[propName]
    var part = encodeURIComponent(propName) + "="
    if (value !== null && value !== "" && typeof (value) !== "undefined") {
      if (typeof value === 'object') {
        for (const key of Object.keys(value)) {
          if (value[key] !== null && value[key] !== "" && typeof (value[key]) !== 'undefined') {
            let params = propName + '[' + key + ']'
            var subPart = encodeURIComponent(params) + "="
            result += subPart + encodeURIComponent(value[key]) + "&"
          }
        }
      } else {
        result += part + encodeURIComponent(value) + "&"
      }
    }
  }
  return result
}

// 判断时间 1 是否小于时间 2
export function checkStartLessEndTime(startTime, endTime) {
  if (startTime === null || startTime?.length === 0 || endTime === null) return true
  // 把数组里的空值过滤掉
  const startDate = new Date()
  startDate.setHours(startTime.split(":")[0])
  startDate.setMinutes(startTime.split(":")[1])
  startDate.setSeconds(startTime.split(":")[2])
  const endDate = new Date()
  endDate.setHours(endTime.split(":")[0])
  endDate.setMinutes(endTime.split(":")[1])
  endDate.setSeconds(endTime.split(":")[2])
  return startDate.getTime() - endDate.getTime() < 0
}
// 判断某个时间是否在指定时间范围中间
export function checkTimeIsBetween(startTime, endTime, time) {
  if (startTime === null || startTime?.length === 0 || endTime === null) return true
  // 把数组里的空值过滤掉
  const startDate = new Date()
  startDate.setHours(startTime.split(":")[0])
  startDate.setMinutes(startTime.split(":")[1])
  startDate.setSeconds(startTime.split(":")[2])
  const endDate = new Date()
  endDate.setHours(endTime.split(":")[0])
  endDate.setMinutes(endTime.split(":")[1])
  endDate.setSeconds(endTime.split(":")[2])
  const checkDate = new Date()
  checkDate.setHours(time.split(":")[0])
  checkDate.setMinutes(time.split(":")[1])
  checkDate.setSeconds(time.split(":")[2])
  return startDate.getTime() - checkDate.getTime() < 0 && checkDate.getTime() - endDate.getTime() < 0
}

// 日期格式化
export function parseTime(time, pattern) {
  if (arguments.length === 0 || !time) {
    return null
  }
  const format = pattern || '{y}-{m}-{d} {h}:{i}:{s}'
  let date
  if (typeof time === 'object') {
    date = time
  } else {
    if ((typeof time === 'string') && (/^[0-9]+$/.test(time))) {
      time = parseInt(time)
    } else if (typeof time === 'string') {

      // 移除时区信息，将时间字符串转换为 UTC 时间
      time = time.replace('T', ' ').replace(/\.\d+\+00:00$/, ''); 
      date = new Date(Date.UTC(...time.split(/[- :]/)));
    }
    if ((typeof time === 'number') && (time.toString().length === 10)) {
      time = time * 1000
    }
    date = new Date(time)
  }
  const formatObj = {
    y: date.getFullYear(),
    m: date.getMonth() + 1,
    d: date.getDate(),
    h: date.getHours(),
    i: date.getMinutes(),
    s: date.getSeconds(),
    a: date.getDay()
  }
  const time_str = format.replace(/{(y|m|d|h|i|s|a)+}/g, (result, key) => {
    let value = formatObj[key]
    // Note: getDay() returns 0 on Sunday
    if (key === 'a') { return ['日', '一', '二', '三', '四', '五', '六'][value] }
    if (result.length > 0 && value < 10) {
      value = '0' + value
    }
    return value || 0
  })
  return time_str
}

// 判断 2 个日期是否为同一天
export function isSameDay(date1, date2) {
  if (!date1 || !date2) return false
  const date1Year = new Date(date1).getFullYear()
  const date1Month = new Date(date1).getMonth() + 1
  const date1Date = new Date(date1).getDate()
  const date2Year = new Date(date2).getFullYear()
  const date2Month = new Date(date2).getMonth() + 1
  const date2Date = new Date(date2).getDate()

  return date1Date === date2Date && date1Month === date2Month && date1Year === date2Year
}

// 把 00:00:00 转成 24:00:00
export const zeroTo24 = (time) => {
  if (time === '00:00:00') {
    return '24:00:00'
  } else {
    return time
  }
}