import Vue from 'vue'
import App from './App'
import store from './store'
import plugins from './plugins'
import './permission'
import config from './config.js'
import { setWxAccessToken } from './utils/auth.js'
Vue.use(plugins)

// 发起请求
uni.request({
  // TODO：将来 TOKEN 从后台获取，再看看如何判定过期与否是响应拦截器里统一处理吗？
  url: `https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=${config.wxAppId}&secret=${config.wxSecret}`,
  success: function (res) {
    setWxAccessToken(res.data.access_token)
    store.commit('SET_TOKEN', res.data.access_token)
  },
  fail: function () {
    console.log('请求 access-token 失败');
  }
});

// console.log(uni.getSystemInfoSync())

Vue.config.productionTip = false
Vue.prototype.$store = store

const app = new Vue({
  ...App
})

app.$mount()
