const qlIP = 'http://192.168.131.48:8011'
const apiUrl = `${qlIP}/user/aliyun/signature` // 后台获取阿里云 OSS 权限信息接口
const ossBaseURL = `https://link-promotion-dev.oss-cn-shanghai.aliyuncs.com/`
// 上传文件
export function uploadFile(fileName, filePath) {
  // 发送请求获取签名信息 
  return new Promise((resolve, reject) => {
    wx.request({
      url: apiUrl,
      success: (res) => {
        const { policy, security_token: xOssSecurityToken, signature: xOssSignature, x_oss_credential: xOssCredential, x_oss_date: xOssDate, x_oss_signature_version: xOssSignatureVersion } = res.data.data;

        //上传参数 
        const formData = {
          key: fileName,  // 上传文件名称（拼接路径格式字符串来决定文件夹）
          policy: policy,   //表单域
          'x-oss-signature-version': xOssSignatureVersion,    //指定签名的版本和算法
          'x-oss-credential': xOssCredential,   //指明派生密钥的参数集
          'x-oss-date': xOssDate,   //请求的时间
          'x-oss-signature': xOssSignature,   //签名认证描述信息
          'x-oss-security-token': xOssSecurityToken,    //安全令牌
          success_action_status: "200"    //上传成功后响应状态码
        }

        // 发送请求上传文件 
        wx.uploadFile({
          url: `https://${res.data.data.web_js_link}`, // Bucket域名 请替换为目标Bucket域名
          filePath: filePath,
          name: 'file', // 固定值为file
          formData: formData,
          success(res) {
            if (res.statusCode === 200) {
              resolve(ossBaseURL + fileName) // 上传成功
            } else {
              reject(res) // 上传失败，返回响应
            }
          },
          fail(err) {
            wx.showToast({ title: '上传失败，请重试!', icon: 'none' });
            reject(err) // 上传失败，返回响应
          }
        });
      },
      fail: (err) => {
        console.error('请求接口失败:', err);
        wx.showToast({ title: '获取上传参数失败，请重试!', icon: 'none' });
        reject(err) // 上传失败，返回响应
      }
    });
  })

}