import request from '@/utils/request'

// 促销员登录
export function loginAPI(data) {
  return request({
    'url': '/user/wechat/query/temporary/login/phone_openid',
    'method': 'post',
    'data': data
  })
}

// 促销员注册
export function submitUserInfoAPI(data) {
  return request({
    'url': '/user/wechat/core/temporary/enroll',
    'method': 'post',
    'data': data
  })
}

// 获取手机号
export function getPhoneNumberAPI(openId, code) {
  return request({
    'url': `/wechat/miniapp/phone?openId=${openId}&code=${code}`
  })
}
// 获取 openId
export function getOpenIdAPI(jsCode) {
  return request({
    'url': `/wechat/miniapp/openid?jsCode=${jsCode}`
  })
}

// 获取快速获取手机号使用次数
export function getPhoneNumberCountAPI(openId) {
  return request({
    'url': `/wechat/miniapp/logincount?openId=${openId}`
  }) 
}