import request from '@/utils/request.js'

// 获取店铺列表
export const getProStoreAPI = () => {
  return request({
    url: '/activity/employee/query/store/page',
    method: 'POST'
  })
}

// 获取今日计划列表
export function getPlanListAPI(queryParams = {}) {
  return request({
    url: '/temporary/activity_plan/query/plans',
    params: {
      city: queryParams.city,
      area: queryParams.area,
      storeNameLike: queryParams.storeNameLike,
    }
  })
}

// 创建促销员今日活动上班
export function createOnWorkPlanAPI(data) {
  return request({
    url: '/activity/temporary/core/today/reported',
    method: 'POST',
    data  
  })
}

// 查询促销员打卡记录
export function getOnWorkRecordAPI(id) {
  return request({
    url: `/temporary/clock/query/${id}`,
    method: 'GET'
  }) 
}

// 上班卡+下班打卡等
export function getOnWorkCardAPI(data) {
  return request({
    url: '/activity/temporary/core/today/clock',
    method: 'POST',
    data
  }) 
}

// 推广照片上报
export function getPromotionPhotoAPI(data) {
  return request({
    url: '/activity/temporary/core/today/reported',
    method: 'POST',
    data
  }) 
}

// 查询推广照片
export function getPromotionPhotoRecordAPI(id) {
  return request({
    url: `/activity/temporary/query/today/${id}`
  }) 
}
