import storage from './utils/storage'
import store from './store'
import constant from './utils/constant'
import { getToken } from '@/utils/auth'

// 登录页面
const loginPage = "/pages/login"

// 页面白名单
const whiteList = [
  '/pages/login', '/pages/register', '/pages/common/webview/index'
]

// 检查地址白名单
function checkWhite(url) {
  const path = url.split('?')[0]
  return whiteList.indexOf(path) !== -1
}

// 页面跳转验证拦截器
let list = ["navigateTo", "redirectTo", "reLaunch", "switchTab"]
list.forEach(item => {
  // 全局添加 API 属性等（拦截路由）
  uni.addInterceptor(item, {
    invoke(to) {
      // 之前是否已经登录过TODO：应该是提交完注册信息后才会有token
      if (getToken()) {
        // 如果已经登录了，还想去登录页面直接跳转到首页
        if (to.url === loginPage) {
          uni.reLaunch({ url: "/pages/home/index" })
        }
        return true
      } else {
        // 未登录，是否去白名单页面
        if (checkWhite(to.url)) {
          return true
        }
        // 未登录，第一次去登录页面
        uni.reLaunch({ url: loginPage })
        return false
      }
    },
    fail(err) {
      console.log(err)
    }
  })
})
