/**
* 显示消息提示框
* @param content 提示的标题
*/
export function toast(content) {
  uni.showToast({
    icon: 'none',
    title: content
  })
}

/**
* 显示模态弹窗
* @param content 提示的标题
*/
export function showConfirm(content) {
  return new Promise((resolve, reject) => {
    uni.showModal({
      title: '提示',
      content: content,
      cancelText: '取消',
      confirmText: '确定',
      success: function (res) {
        resolve(res)
      }
    })
  })
}

/**
* 参数处理
* @param params 参数
*/
export function tansParams(params) {
  let result = ''
  for (const propName of Object.keys(params)) {
    const value = params[propName]
    var part = encodeURIComponent(propName) + "="
    if (value !== null && value !== "" && typeof (value) !== "undefined") {
      if (typeof value === 'object') {
        for (const key of Object.keys(value)) {
          if (value[key] !== null && value[key] !== "" && typeof (value[key]) !== 'undefined') {
            let params = propName + '[' + key + ']'
            var subPart = encodeURIComponent(params) + "="
            result += subPart + encodeURIComponent(value[key]) + "&"
          }
        }
      } else {
        result += part + encodeURIComponent(value) + "&"
      }
    }
  }
  return result
}

// 判断时间 1 是否小于时间 2
export function checkStartLessEndTime(startTime, endTime) {
  if (startTime === null || startTime?.length === 0 || endTime === null) return true
  // 把数组里的空值过滤掉
  const startDate = new Date()
  startDate.setHours(startTime.split(":")[0])
  startDate.setMinutes(startTime.split(":")[1])
  startDate.setSeconds(startTime.split(":")[2])
  const endDate = new Date()
  endDate.setHours(endTime.split(":")[0])
  endDate.setMinutes(endTime.split(":")[1])
  endDate.setSeconds(endTime.split(":")[2])
  return startDate.getTime() - endDate.getTime() < 0
}