import store from '@/store'
const getters = {
  token: state => state.user.token,
  avatar: state => state.user.avatar,
  user: state => state.user.user,
  name: state => state.user.name,
  roles: state => state.user.roles,
  permissions: state => state.user.permissions,
  delayTime: state => 3000, // 延迟弹窗关闭时间
  location: (state) => {
    // 发现有则返回，没有则获取并赋予
    return new Promise(async (resolve, reject) => {
      if (state.map.location) {
        resolve(state.map.location)
      } else {
        const location = await store.dispatch('GetLocation')
        state.map.location = location
        resolve(location) 
      }
    })
  }
}
export default getters
