import request from '@/utils/request.js'


/**
 * 获取考勤规则详情
 * @param {*} ruleId 考勤规则 ID
 * @returns 
 */
export const getAttendanceDetailAPI = (ruleId) => {
	return request({
		url: `/system/kq_rule/${ruleId}`
	})
}

/**
 * 考勤打卡
 * @param {*} data 
 * @returns 
 */
export const addAttendanceAPI = (data) => {
	return request({
		url: '/operation/kqmx/core',
		method: 'post',
		data
	})
}