package com.link.report.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.CustomerJimuReportDao;
import com.link.report.domain.entity.CustomerJimuReport;
import com.link.report.domain.mapper.CustomerJimuReportMapper;
import com.link.report.pojo.response.CustomerJimuReportDto;
import com.sfa.common.core.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 报表分享数据
 */
@Component
public class CustomerJimuReportDaoImpl implements CustomerJimuReportDao {
    @Autowired
    private CustomerJimuReportMapper customerJimuReportMapper;


    @Override
    public CustomerJimuReportDto queryByName(String reportName) {
        CustomerJimuReport jimuReport = customerJimuReportMapper.selectOne(new LambdaQueryWrapper<CustomerJimuReport>()
                .eq(CustomerJimuReport::getName, reportName));
        return BeanUtils.transitionDto(jimuReport, CustomerJimuReportDto.class);
    }

    @Override
    public void updateTenentId(CustomerJimuReportDto customerJimuReportDto) {
        CustomerJimuReport report = BeanUtils.transitionDto(customerJimuReportDto, CustomerJimuReport.class);
        customerJimuReportMapper.updateById(report);
    }
}
