package com.link.report.pojo.request;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * QuickBI报表嵌入信息BO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExtraReportQuickbiEmbedBo implements Serializable {

    private static final long serialVersionUID = 1L;
    private Long id;

    /**
     * QuickBI报表名称
     */
    private String name;

    /**
     * 报表预览访问地址
     */
    private String previewUrl;

    /**
     * QuickBI报表唯一标识ID
     */
    private String pageId;

    /**
     * 报表访问凭证（临时票据）
     */
    private String accessTicket;

    /**
     * 报表类型，如：普通报表、仪表盘、数据门户等
     */
    private String reportType;
}
