package com.link.report.domain.entity;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import java.util.Date;

/**
 * 对应数据库自定义分组表 customer_group 的 Java Bean 类
 */
@TableName(value ="customer_group")
@Data
public class CustomerGroup {
    /**
     * 主键
     */
    private String id;
    /**
     * 分组名称
     */
    private String name;
    /**
     * 说明
     */
    private String remark;
    /**
     * 分类名称
     */
    private String categoryName;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改人
     */
    private String updateBy;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 删除标识，0 表示正常，1 表示已删除
     */
    @TableLogic
    private Integer delFlag;
    /**
     * 多租户标识
     */
    private String tenantId;
    /**
     * 乐观锁版本
     */
    private Integer updateCount;
    private Long createUserId;
     private Long updateUserId;
}
