package com.link.report.service.query.impl;

import com.link.report.domain.dao.JimuReportCategoryQueryDao;
import com.link.report.domain.entity.JimuReportCategory;
import com.link.report.pojo.request.JimuReportCategoryVo;
import com.link.report.pojo.response.JimuReportCategoryDto;
import com.link.report.service.query.JimuReportCategoryQueryService;
import com.sfa.common.core.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表文件夹数据
 */
@Service
public class JimuReportCategoryQueryServiceImpl implements JimuReportCategoryQueryService {
    @Autowired
    private JimuReportCategoryQueryDao categoryQueryDao;

    /**
     * 查询积木报表文件列表
     * @param categoryVo
     * @return
     */
    @Override
    public List<JimuReportCategoryDto> selectList(JimuReportCategoryVo categoryVo) {
        JimuReportCategory category = new JimuReportCategory();
        BeanUtils.copyBeanProp(categoryVo, category);

        List<JimuReportCategory> jimuReportCategories = categoryQueryDao.queryList(category);
        List<JimuReportCategoryDto> categoryDtos = BeanUtils.transitionDtos(jimuReportCategories, JimuReportCategoryDto.class);
        return categoryDtos;
    }
}
