package com.link.report.service.query.impl;

import cn.hutool.core.util.ObjectUtil;
import com.link.report.domain.dao.CustomerReportDao;
import com.link.report.domain.entity.CustomerReport;
import com.link.report.domain.wq.CustomerReportQueryWq;
import com.link.report.pojo.request.CustomerReportAddVo;
import com.link.report.pojo.request.ReportShareListVo;
import com.link.report.pojo.response.CustomerReportListDto;
import com.link.report.service.query.CustomerReportService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表分享数据
 */
@Service
public class CustomerReportServiceImpl implements CustomerReportService {

    @Autowired
    private CustomerReportDao customerReportDao;

    @Override
    public void save(CustomerReportAddVo customerReportAddVo) {
        CustomerReport customerReport = new CustomerReport();
        BeanUtils.copyProperties(customerReportAddVo, customerReport);
        customerReport.setName(customerReportAddVo.getName());
        customerReport.setPreviewUrl(customerReportAddVo.getPreviewUrl());
        customerReport.setCreateBy(SecurityUtils.getUsername());
        customerReport.setUpdateBy(SecurityUtils.getUsername());
        customerReport.setCreateUserId(SecurityUtils.getUserId());
        customerReport.setUpdateUserId(SecurityUtils.getUserId());

        if (ObjectUtil.isNotEmpty(customerReport.getId())) {
            customerReportDao.update(customerReport);
        } else {
            customerReportDao.insert(customerReport);
        }
    }

    @Override
    public List<CustomerReportListDto> queryCustomerReportList(ReportShareListVo reportShareListVo) {
        CustomerReportQueryWq wq = new CustomerReportQueryWq();
        wq.setCategoryName(reportShareListVo.getCategoryName());
        List<CustomerReportListDto> list = customerReportDao.queryCustomerReportList(wq);
        return list;
    }
}
